<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:ta1="http://www.sec.gov/edgar/ta/taonefiler">

	<xsl:template name="item3_applicantAffiliateDiscHistoryInfo"
		match="ta1:disciplinaryHistory">
		<h1>
			<xsl:value-of select="$submissionType" />
			: 10. Applicant and Control Affiliate Disciplinary History
		</h1>
      <p></p>
      <p>
			The following definitions apply for purposes of
			answering this Question 10  
		</p>
		<table role="presentation">
			<tr>
				<td valign="top">Control Affiliate</td>
				<td>- An individual or firm that directly or indirectly controls, is under common control
					with, or is controlled by applicant. Included are any employees identified in 8(a), 8(b), 8(c) of this form as exercising
					control. Excluded are any employees who perform solely clerical, administrative support of similar functions, or who, regardless of
					title, perform no executive duties or have no senior policy making authority. 
				</td>
			</tr>
			<tr>
				<td valign="top">Investment or investment related</td>
				<td>- Pertaining to securities, commodities, banking, insurance, or real estate
			  		(including, but not limited to, acting as or being associated with
			  		a broker dealer, investment company, investment adviser, futures
			  		sponsor, bank, or savings and loan association).
			  </td>
			</tr>
			<tr>
			  <td valign="top">Involved</td>
			  <td>- Doing an act of aiding, abetting, counseling, commanding, inducing,
			  		conspiring with or failing reasonably to supervise another in
			  		doing an act.</td>
			</tr>
		</table>
      <p></p>
      <p>
			<b>10(a). </b>
			In the past ten years has the applicant or a control affiliate
			been convicted of or plead guilty or nolo contendere ("no contest")
			to:
		</p>
      <table role="presentation">
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">10(a)(1). </font>
					</b>
					a felony or misdemeanor involving: investments or an
					investment-related business, fraud, false statements or omissions,
					wrongful taking of property, or bribery, forgery, counterfeiting,
					or extortion?
				</td>
				<td>
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:disciplinaryHistory/ta1:felonyOrMisdemeanor/ta1:involved = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:disciplinaryHistory/ta1:felonyOrMisdemeanor/ta1:involved = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
		</table>	
			<xsl:if test="ta1:formData/ta1:disciplinaryHistory/ta1:felonyOrMisdemeanor/ta1:involved = 'Y'">
				<xsl:for-each
					select="ta1:formData/ta1:disciplinaryHistory/ta1:felonyOrMisdemeanor/ta1:felonyOrMisdemeanorDetails">
					<xsl:call-template name="mode_felonyOrMisdemeanorDetails" />
				</xsl:for-each>
			</xsl:if>
     <table role="presentation">
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">10(a)(2). </font>
					</b>
					any other felony?
				</td>
				<td>
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:disciplinaryHistory/ta1:otherFelony/ta1:involved = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:disciplinaryHistory/ta1:otherFelony/ta1:involved = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
			</table>
			<xsl:if test="ta1:formData/ta1:disciplinaryHistory/ta1:otherFelony/ta1:involved = 'Y'">
				<xsl:for-each select="ta1:formData/ta1:disciplinaryHistory/ta1:otherFelony/ta1:otherFelonyDetails">
					<xsl:call-template name="mode_otherFelonyDetails" />
				</xsl:for-each>
			</xsl:if>
			
     <table role="presentation">
			<tr>
				<td class="label">
					<font color="black">
						<b>10(b). </b>
						Has any court in the past ten years:
					</font>
				</td>
			</tr>
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">10(b)(1). </font>
					</b>
					enjoined the applicant or a control affiliate in connection with
					any investment-related activity?
				</td>
				<td>
						<xsl:choose>
							<xsl:when
								test="ta1:formData/ta1:disciplinaryHistory/ta1:enjoinedInvestmentRelatedActivity/ta1:involved = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when
								test="ta1:formData/ta1:disciplinaryHistory/ta1:enjoinedInvestmentRelatedActivity/ta1:involved = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
			</table>
			<xsl:if test="ta1:formData/ta1:disciplinaryHistory/ta1:enjoinedInvestmentRelatedActivity/ta1:involved = 'Y'">
				<xsl:for-each
					select="ta1:formData/ta1:disciplinaryHistory/ta1:enjoinedInvestmentRelatedActivity/ta1:enjoinedInvestmentRelatedActivityDetails">
					<xsl:call-template name="mode_enjoinedInvestmentRelatedActivityDetails" />
				</xsl:for-each>
			</xsl:if>
			
     <table role="presentation">
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">10(b)(2). </font>
					</b>
					found that the applicant or control affiliate was involved in a
					violation of investment-related statutes or regulations?
				</td>
				<td>
						<xsl:choose>
							<xsl:when
								test="ta1:formData/ta1:disciplinaryHistory/ta1:violationOfInvestmentRelatedRegulation/ta1:involved = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when
								test="ta1:formData/ta1:disciplinaryHistory/ta1:violationOfInvestmentRelatedRegulation/ta1:involved = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
		</table>	
		
			<xsl:if test="ta1:formData/ta1:disciplinaryHistory/ta1:violationOfInvestmentRelatedRegulation/ta1:involved = 'Y'">
				<xsl:for-each
					select="ta1:formData/ta1:disciplinaryHistory/ta1:violationOfInvestmentRelatedRegulation/ta1:violationOfInvestmentRelatedRegulationDetails">
					<xsl:call-template
						name="mode_violationOfInvestmentRelatedRegulationDetails" />
				</xsl:for-each>
			</xsl:if>

		<table role="presentation">
			<tr>
				<td class="label">
					<font color="black">
						<b>10 (c). </b>
						Has the U.S. Securities and Exchange Commission or the Commodity
						Futures Trading Commission ever:
					</font>
				</td>
			</tr>
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">10(c)(1). </font>
					</b>
					found the applicant or control affiliate to have made a false
					statement or omission?
				</td>
				<td>
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:disciplinaryHistory/ta1:falseStatementOrOmission/ta1:involved = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:disciplinaryHistory/ta1:falseStatementOrOmission/ta1:involved = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
		</table>
			<xsl:if test="ta1:formData/ta1:disciplinaryHistory/ta1:falseStatementOrOmission/ta1:involved = 'Y'">
				<xsl:for-each
					select="ta1:formData/ta1:disciplinaryHistory/ta1:falseStatementOrOmission/ta1:falseStatementOrOmissionDetails">
					<xsl:call-template name="mode_falseStatementOrOmissionDetails" />
				</xsl:for-each>
			</xsl:if>
			
		<table role="presentation">			
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">10(c)(2). </font>
					</b>
					found the applicant or control affiliate to have been involved in
					a violation of its regulation or statutes?
				</td>
				<td>
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:disciplinaryHistory/ta1:violationOfRegulations/ta1:involved = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:disciplinaryHistory/ta1:violationOfRegulations/ta1:involved = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
			</table>
			<xsl:if test="ta1:formData/ta1:disciplinaryHistory/ta1:violationOfRegulations/ta1:involved = 'Y'">
				<xsl:for-each
					select="ta1:formData/ta1:disciplinaryHistory/ta1:violationOfRegulations/ta1:violationOfRegulationsDetails">
					<xsl:call-template name="mode_violationOfRegulationsDetails" />
				</xsl:for-each>
			</xsl:if>

		<table role="presentation">				
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">10(c)(3). </font>
					</b>
					found the applicant or control affiliate to have been a cause of
					an investment-related business having its authorization to do
					business denied, suspended, revoked or restricted?
				</td>
				<td>
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:disciplinaryHistory/ta1:authorizationDeniedOrSuspended/ta1:involved = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:disciplinaryHistory/ta1:authorizationDeniedOrSuspended/ta1:involved = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
		</table>	
			<xsl:if test="ta1:formData/ta1:disciplinaryHistory/ta1:authorizationDeniedOrSuspended/ta1:involved = 'Y'">
				<xsl:for-each
					select="ta1:formData/ta1:disciplinaryHistory/ta1:authorizationDeniedOrSuspended/ta1:authorizationDeniedOrSuspendedDetails">
					<xsl:call-template name="mode_authorizationDeniedOrSuspendedDetails" />
				</xsl:for-each>
			</xsl:if>
			
		<table role="presentation">	
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">10(c)(4). </font>
					</b>
					entered an order denying, suspending or revoking the applicant’s
					or control affiliate’s registration or otherwise disciplined it by
					restricting its activities?
				</td>
				<td>
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:disciplinaryHistory/ta1:registrationDeniedOrSuspended/ta1:involved = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:disciplinaryHistory/ta1:registrationDeniedOrSuspended/ta1:involved = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
		</table>
			<xsl:if test="ta1:formData/ta1:disciplinaryHistory/ta1:registrationDeniedOrSuspended/ta1:involved = 'Y'">
				<xsl:for-each
					select="ta1:formData/ta1:disciplinaryHistory/ta1:registrationDeniedOrSuspended/ta1:registrationDeniedOrSuspendedDetails">
					<xsl:call-template name="mode_registrationDeniedOrSuspendedDetails" />
				</xsl:for-each>
			</xsl:if>

			<!-- *10(d). Has any other Federal regulatory agency or any state regulatory 
				agency : -->
		<table role="presentation">					
			<tr>
				<td class="label">
					<font color="black">
						<b>10(d). </b>
						Has any other Federal regulatory agency or any state regulatory
						agency :
					</font>
				</td>
			</tr>
			<!-- 10(d)(1) -->
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">10(d)(1). </font>
					</b>
					ever found the applicant or control affiliate to have made a false
					statement or omission or to have been dishonest, unfair, or
					unethical?
				</td>
				<td>
						<xsl:choose>
							<xsl:when
								test="ta1:formData/ta1:disciplinaryHistory/ta1:federalOrStateRegulatoryAgency/ta1:fsrFalseStatementOrOmission/ta1:involved = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when
								test="ta1:formData/ta1:disciplinaryHistory/ta1:federalOrStateRegulatoryAgency/ta1:fsrFalseStatementOrOmission/ta1:involved = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
			</table>
			<xsl:if
				test="ta1:formData/ta1:disciplinaryHistory/ta1:federalOrStateRegulatoryAgency/ta1:fsrFalseStatementOrOmission/ta1:involved = 'Y'">
				<xsl:for-each
					select="ta1:formData/ta1:disciplinaryHistory/ta1:federalOrStateRegulatoryAgency/ta1:fsrFalseStatementOrOmission/ta1:fsrFalseStatementOrOmissionDetails">
					<xsl:call-template name="mode_fsrFalseStatementOrOmissionDetails" />
				</xsl:for-each>
			</xsl:if>
			<!-- 10(d)(2) -->
			
		<table role="presentation">	
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">10(d)(2). </font>
					</b>
					ever found the applicant or control affiliate to have been
					involved in a violation of investment-related regulations or
					statutes?
				</td>
				<td>
						<xsl:choose>
							<xsl:when
								test="ta1:formData/ta1:disciplinaryHistory/ta1:federalOrStateRegulatoryAgency/ta1:fsrViolationOfInvestmentRelatedRegulation/ta1:involved = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when
								test="ta1:formData/ta1:disciplinaryHistory/ta1:federalOrStateRegulatoryAgency/ta1:fsrViolationOfInvestmentRelatedRegulation/ta1:involved = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
			</table>
			<xsl:if
				test="ta1:formData/ta1:disciplinaryHistory/ta1:federalOrStateRegulatoryAgency/ta1:fsrViolationOfInvestmentRelatedRegulation/ta1:involved = 'Y'">
				<xsl:for-each
					select="ta1:formData/ta1:disciplinaryHistory/ta1:federalOrStateRegulatoryAgency/ta1:fsrViolationOfInvestmentRelatedRegulation/ta1:fsrViolationOfInvestmentRelatedRegulationDetails">
					<xsl:call-template
						name="mode_fsrViolationOfInvestmentRelatedRegulationDetails" />
				</xsl:for-each>
			</xsl:if>
			<!-- 10(d)(3) -->
		<table role="presentation">				
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">10(d)(3). </font>
					</b>
					ever found the applicant or control affiliate to have been a cause
					of an investment-related business having its authorization to do
					business Denied, suspended, revoked or restricted?
				</td>
				<td>
						<xsl:choose>
							<xsl:when
								test="ta1:formData/ta1:disciplinaryHistory/ta1:federalOrStateRegulatoryAgency/ta1:fsrAuthorizationDeniedOrSuspended/ta1:involved = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when
								test="ta1:formData/ta1:disciplinaryHistory/ta1:federalOrStateRegulatoryAgency/ta1:fsrAuthorizationDeniedOrSuspended/ta1:involved = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
			</table>
			<xsl:if
				test="ta1:formData/ta1:disciplinaryHistory/ta1:federalOrStateRegulatoryAgency/ta1:fsrAuthorizationDeniedOrSuspended/ta1:involved = 'Y'">
				<xsl:for-each
					select="ta1:formData/ta1:disciplinaryHistory/ta1:federalOrStateRegulatoryAgency/ta1:fsrAuthorizationDeniedOrSuspended/ta1:fsrAuthorizationDeniedOrSuspendedDetails">
					<xsl:call-template name="mode_fsrAuthorizationDeniedOrSuspendedDetails" />
				</xsl:for-each>
			</xsl:if>
			<!-- 10(d)(4) -->
			
		<table role="presentation">	
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">10(d)(4). </font>
					</b>
					in the past ten years entered an order against the applicant or
					control affiliate in connection with investment-related activity?
				</td>
				<td>
						<xsl:choose>
							<xsl:when
								test="ta1:formData/ta1:disciplinaryHistory/ta1:federalOrStateRegulatoryAgency/ta1:fsrFoundOrderAgainstApplicant/ta1:involved = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when
								test="ta1:formData/ta1:disciplinaryHistory/ta1:federalOrStateRegulatoryAgency/ta1:fsrFoundOrderAgainstApplicant/ta1:involved = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
			</table>
			<xsl:if
				test="ta1:formData/ta1:disciplinaryHistory/ta1:federalOrStateRegulatoryAgency/ta1:fsrFoundOrderAgainstApplicant/ta1:involved = 'Y'">
				<xsl:for-each
					select="ta1:formData/ta1:disciplinaryHistory/ta1:federalOrStateRegulatoryAgency/ta1:fsrFoundOrderAgainstApplicant/ta1:fsrFoundOrderAgainstApplicantDetails">
					<xsl:call-template name="mode_fsrFoundOrderAgainstApplicantDetails" />
				</xsl:for-each>
			</xsl:if>
			<!-- 10(d)(5) -->
			
		<table role="presentation">				
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">10(d)(5). </font>
					</b>
					ever denied, suspended, or revoked applicant’s or control
					affiliate’s registration or license, or prevented it from
					associating with an investment-related business, or otherwise
					disciplined it by restricting its activities?
				</td>
				<td>
						<xsl:choose>
							<xsl:when
								test="ta1:formData/ta1:disciplinaryHistory/ta1:federalOrStateRegulatoryAgency/ta1:fsrRegistrationDeniedOrSuspended/ta1:involved = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when
								test="ta1:formData/ta1:disciplinaryHistory/ta1:federalOrStateRegulatoryAgency/ta1:fsrRegistrationDeniedOrSuspended/ta1:involved = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
		</table>	
			<xsl:if
				test="ta1:formData/ta1:disciplinaryHistory/ta1:federalOrStateRegulatoryAgency/ta1:fsrRegistrationDeniedOrSuspended/ta1:involved = 'Y'">
				<xsl:for-each
					select="ta1:formData/ta1:disciplinaryHistory/ta1:federalOrStateRegulatoryAgency/ta1:fsrRegistrationDeniedOrSuspended/ta1:fsrRegistrationDeniedOrSuspendedDetails">
					<xsl:call-template name="mode_fsrRegistrationDeniedOrSuspendedDetails" />
				</xsl:for-each>
			</xsl:if>
			<!-- 10(d)(6) -->
		<table role="presentation">	
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">10(d)(6). </font>
					</b>
					ever revoked or suspended the applicant’s or a control affiliate’s
					license as an attorney or accountant?
				</td>
				<td>
						<xsl:choose>
							<xsl:when
								test="ta1:formData/ta1:disciplinaryHistory/ta1:federalOrStateRegulatoryAgency/ta1:fsrRevokedSuspendedLicense/ta1:involved = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when
								test="ta1:formData/ta1:disciplinaryHistory/ta1:federalOrStateRegulatoryAgency/ta1:fsrRevokedSuspendedLicense/ta1:involved = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
			</table>
			
			<xsl:if
				test="ta1:formData/ta1:disciplinaryHistory/ta1:federalOrStateRegulatoryAgency/ta1:fsrRevokedSuspendedLicense/ta1:involved = 'Y'">
				<xsl:for-each
					select="ta1:formData/ta1:disciplinaryHistory/ta1:federalOrStateRegulatoryAgency/ta1:fsrRevokedSuspendedLicense/ta1:fsrRevokedSuspendedLicenseDetails">
					<xsl:call-template name="mode_fsrRevokedSuspendedLicenseDetails" />
				</xsl:for-each>
			</xsl:if>

			<!-- 10(e). -->
		<p></p>
		<b>10(e). </b>Has any self-regulatory organization or commodities exchange ever:	
			
		<table role="presentation">				
			<!-- 10(e)(1) -->
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">10(e)(1). </font>
					</b>
					found the applicant or a control affiliate to have made a false
					statement or omission?
				</td>
				<td>
						<xsl:choose>
							<xsl:when
								test="ta1:formData/ta1:disciplinaryHistory/ta1:selfRegulatoryAgency/ta1:sraFalseStatementOrOmission/ta1:involved = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when
								test="ta1:formData/ta1:disciplinaryHistory/ta1:selfRegulatoryAgency/ta1:sraFalseStatementOrOmission/ta1:involved = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
		</table>
			
			<xsl:if
				test="ta1:formData/ta1:disciplinaryHistory/ta1:selfRegulatoryAgency/ta1:sraFalseStatementOrOmission/ta1:involved = 'Y'">
				<xsl:for-each
					select="ta1:formData/ta1:disciplinaryHistory/ta1:selfRegulatoryAgency/ta1:sraFalseStatementOrOmission/ta1:sraFalseStatementOrOmissionDetails">
					<xsl:call-template name="mode_sraFalseStatementOrOmissionDetails" />
				</xsl:for-each>
			</xsl:if>
			<!-- 10(e)(2) -->
		<table role="presentation">	
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">10(e)(2). </font>
					</b>
					found the applicant or a control affiliate to have been involved
					in a violation of its rules?
				</td>
				<td>
						<xsl:choose>
							<xsl:when
								test="ta1:formData/ta1:disciplinaryHistory/ta1:selfRegulatoryAgency/ta1:sraViolationOfRules/ta1:involved = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when
								test="ta1:formData/ta1:disciplinaryHistory/ta1:selfRegulatoryAgency/ta1:sraViolationOfRules/ta1:involved = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
		</table>
			<xsl:if
				test="ta1:formData/ta1:disciplinaryHistory/ta1:selfRegulatoryAgency/ta1:sraViolationOfRules/ta1:involved = 'Y'">
				<xsl:for-each
					select="ta1:formData/ta1:disciplinaryHistory/ta1:selfRegulatoryAgency/ta1:sraViolationOfRules/ta1:sraViolationOfRulesDetails">
					<xsl:call-template name="mode_sraViolationOfRulesDetails" />
				</xsl:for-each>
			</xsl:if>
			
			<!-- 10(e)(3) -->
		<table role="presentation">	
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">10(e)(3). </font>
					</b>
					found the applicant or a control affiliate to have been the cause
					of an investment-related business losing its authorization to do
					business?
				</td>
				<td>
						<xsl:choose>
							<xsl:when
								test="ta1:formData/ta1:disciplinaryHistory/ta1:selfRegulatoryAgency/ta1:sraAuthorizationDeniedOrSuspended/ta1:involved = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when
								test="ta1:formData/ta1:disciplinaryHistory/ta1:selfRegulatoryAgency/ta1:sraAuthorizationDeniedOrSuspended/ta1:involved = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
		</table>	
			<xsl:if
				test="ta1:formData/ta1:disciplinaryHistory/ta1:selfRegulatoryAgency/ta1:sraAuthorizationDeniedOrSuspended/ta1:involved = 'Y'">
				<xsl:for-each
					select="ta1:formData/ta1:disciplinaryHistory/ta1:selfRegulatoryAgency/ta1:sraAuthorizationDeniedOrSuspended/ta1:sraAuthorizationDeniedOrSuspendedDetails">
					<xsl:call-template name="mode_sraAuthorizationDeniedOrSuspendedDetails" />
				</xsl:for-each>
			</xsl:if>
			
			<!-- 10(e)(4) -->
		<table role="presentation">
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">10(e)(4). </font>
					</b>
					disciplined the applicant or a control affiliate by expelling or
					suspending it from membership, by barring or suspending its
					association with other members, or by otherwise restricting its
					activities?
				</td>
				<td>
						<xsl:choose>
							<xsl:when
								test="ta1:formData/ta1:disciplinaryHistory/ta1:selfRegulatoryAgency/ta1:sraRevokedSuspendedLicense/ta1:involved = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when
								test="ta1:formData/ta1:disciplinaryHistory/ta1:selfRegulatoryAgency/ta1:sraRevokedSuspendedLicense/ta1:involved = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
		</table>	
			<xsl:if
				test="ta1:formData/ta1:disciplinaryHistory/ta1:selfRegulatoryAgency/ta1:sraRevokedSuspendedLicense/ta1:involved = 'Y'">
				<xsl:for-each
					select="ta1:formData/ta1:disciplinaryHistory/ta1:selfRegulatoryAgency/ta1:sraRevokedSuspendedLicense/ta1:sraRevokedSuspendedLicenseDetails">
					<xsl:call-template name="mode_sraRevokedSuspendedLicenseDetails" />
				</xsl:for-each>
			</xsl:if>
			
			<!-- 10(f). -->
		<table role="presentation">			
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">10(f). </font>
					</b>
					Has any foreign government, court, regulatory agency or exchange
					ever entered an order against the applicant or a control affiliate
					related to investments or fraud?
				</td>
				<td>
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:disciplinaryHistory/ta1:foreignAgency/ta1:involved = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:disciplinaryHistory/ta1:foreignAgency/ta1:involved = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
		</table>
			<xsl:if test="ta1:formData/ta1:disciplinaryHistory/ta1:foreignAgency/ta1:involved = 'Y'">
				<xsl:for-each select="ta1:formData/ta1:disciplinaryHistory/ta1:foreignAgency/ta1:foreignAgencyDetails">
					<xsl:call-template name="mode_foreignAgencyDetails" />
				</xsl:for-each>
			</xsl:if>
			
			<!-- 10(g). -->
		<table role="presentation">			
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">10(g). </font>
					</b>
					Is the applicant or a control affiliate now the subject of a
					proceeding that could result in a yes answer for questions 10(a) –
					10(f) ?
				</td>
				<td>
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:disciplinaryHistory/ta1:subjectOfProceedings/ta1:involved = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:disciplinaryHistory/ta1:subjectOfProceedings/ta1:involved = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
		</table>	
			<xsl:if test="ta1:formData/ta1:disciplinaryHistory/ta1:subjectOfProceedings/ta1:involved = 'Y'">
				<xsl:for-each
					select="ta1:formData/ta1:disciplinaryHistory/ta1:subjectOfProceedings/ta1:subjectOfProceedingsDetails">
					<xsl:call-template name="mode_subjectOfProceedingsDetails" />
				</xsl:for-each>
			</xsl:if>
			
			<!-- 10(h) -->
		<table role="presentation">			
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">10(h). </font>
					</b>
					Has a bonding company denied, paid out on, or revoked a bond for
					the applicant or a control affiliate?
				</td>
				<td>
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:disciplinaryHistory/ta1:revokedBond/ta1:involved = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:disciplinaryHistory/ta1:revokedBond/ta1:involved = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
		</table>	
			<xsl:if test="ta1:formData/ta1:disciplinaryHistory/ta1:revokedBond/ta1:involved = 'Y'">
				<xsl:for-each select="ta1:formData/ta1:disciplinaryHistory/ta1:revokedBond/ta1:revokedBondDetails">
					<xsl:call-template name="mode_revokedBondDetails" />
				</xsl:for-each>
			</xsl:if>
			
			<!-- 10(i) -->
		<table role="presentation">	
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">10(i). </font>
					</b>
					Does the applicant or a control affiliate have any unsatisfied
					judgments or liens against it?
				</td>
				<td>
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:disciplinaryHistory/ta1:unsatisfiedJudgementsOrLiens/ta1:involved = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:disciplinaryHistory/ta1:unsatisfiedJudgementsOrLiens/ta1:involved = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
		</table>	
			<xsl:if test="ta1:formData/ta1:disciplinaryHistory/ta1:unsatisfiedJudgementsOrLiens/ta1:involved = 'Y'">
				<xsl:for-each
					select="ta1:formData/ta1:disciplinaryHistory/ta1:unsatisfiedJudgementsOrLiens/ta1:unsatisfiedJudgementOrLiensDetails">
					<xsl:call-template name="mode_unsatisfiedJudgementOrLiensDetails" />
				</xsl:for-each>
			</xsl:if>

	</xsl:template>

	<!-- 10(a)(i) -->
	<xsl:template name="mode_felonyOrMisdemeanorDetails">
     <p>
				Entity information Related to item 10(a)(1) Record:
				<xsl:value-of select="position()" />
	  </p>
    <table role="presentation">
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(a)(1)(i). </b>
				</font>
				The individuals named in the Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(a)(1)(ii). </b>
				</font>
				Title of Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:actionTitle" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(a)(1)(iii). </b>
				</font>
				Date of Action
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:actionDate" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(a)(1)(iv). </b>
				</font>
				The Court or body taking the Action and its location
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:courtOrBodyNameAndLocation" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(a)(1)(v). </b>
				</font>
				Description of the Action
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:actionDescription" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(a)(1)(vi). </b>
				</font>
				The disposition of the proceeding
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:dispositionOfProceeding" />
				</div>
			</td>
		</tr>
		</table>
	</xsl:template>
	<xsl:template name="mode_otherFelonyDetails">
           <p>
				Entity information Related to item 10(a)(2) Record:
				<xsl:value-of select="position()" />
			  </p>
    <table role="presentation">
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(a)(2)(i). </b>
				</font>
				The individuals named in the Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(a)(2)(ii). </b>
				</font>
				Title of Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:actionTitle" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(a)(2)(iii). </b>
				</font>
				Date of Action
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:actionDate" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(a)(2)(iv). </b>
				</font>
				The Court or body taking the Action and its location
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:courtOrBodyNameAndLocation" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(a)(2)(v). </b>
				</font>
				Description of the Action
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:actionDescription" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(a)(2)(vi). </b>
				</font>
				The disposition of the proceeding
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:dispositionOfProceeding" />
				</div>
			</td>
		</tr>
		</table>
	</xsl:template>

	<xsl:template name="mode_enjoinedInvestmentRelatedActivityDetails">
      <p>
				Entity information Related to item 10(b)(1) Record:
				<xsl:value-of select="position()" />
		</p>
    <table role="presentation">
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(b)(1)(i). </b>
				</font>
				The individuals named in the Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(b)(1)(ii). </b>
				</font>
				Title of Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:actionTitle" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(b)(1)(iii). </b>
				</font>
				Date of Action
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:actionDate" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(b)(1)(iv). </b>
				</font>
				The Court or body taking the Action and its location
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:courtOrBodyNameAndLocation" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(b)(1)(v). </b>
				</font>
				Description of the Action
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:actionDescription" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(b)(1)(vi). </b>
				</font>
				The disposition of the proceeding
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:dispositionOfProceeding" />
				</div>
			</td>
		</tr>
	</table>	
	</xsl:template>
	
	<xsl:template name="mode_violationOfInvestmentRelatedRegulationDetails">
       <p>
				Entity information Related to item 10(b)(2) Record:
				<xsl:value-of select="position()" />
		 </p>
    <table role="presentation">
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(b)(2)(i). </b>
				</font>
				The individuals named in the Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(b)(2)(ii). </b>
				</font>
				Title of Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:actionTitle" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(b)(2)(iii). </b>
				</font>
				Date of Action
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:actionDate" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(b)(2)(iv). </b>
				</font>
				The Court or body taking the Action and its location
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:courtOrBodyNameAndLocation" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(b)(2)(v). </b>
				</font>
				Description of the Action
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:actionDescription" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(b)(2)(vi). </b>
				</font>
				The disposition of the proceeding
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:dispositionOfProceeding" />
				</div>
			</td>
		</tr>
	 </table>
	</xsl:template>


	<xsl:template name="mode_falseStatementOrOmissionDetails">
      <p>
				Entity information Related to item 10(c)(1) Record:
				<xsl:value-of select="position()" />
		</p>
    <table role="presentation">
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(c)(1)(i). </b>
				</font>
				The individuals named in the Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(c)(1)(ii). </b>
				</font>
				Title of Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:actionTitle" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(c)(1)(iii). </b>
				</font>
				Date of Action
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:actionDate" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(c)(1)(iv). </b>
				</font>
				The Court or body taking the Action and its location
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:courtOrBodyNameAndLocation" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(c)(1)(v). </b>
				</font>
				Description of the Action
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:actionDescription" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(c)(1)(vi). </b>
				</font>
				The disposition of the proceeding
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:dispositionOfProceeding" />
				</div>
			</td>
		</tr>
		</table>
	</xsl:template>
	<xsl:template name="mode_violationOfRegulationsDetails">
      <p>
				Entity information Related to item 10(c)(2) Record:
				<xsl:value-of select="position()" />
		</p>
    <table role="presentation">
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(c)(2)(i). </b>
				</font>
				The individuals named in the Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(c)(2)(ii). </b>
				</font>
				Title of Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:actionTitle" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(c)(2)(iii). </b>
				</font>
				Date of Action
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:actionDate" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(c)(2)(iv). </b>
				</font>
				The Court or body taking the Action and its location
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:courtOrBodyNameAndLocation" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(c)(2)(v). </b>
				</font>
				Description of the Action
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:actionDescription" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(c)(2)(vi). </b>
				</font>
				The disposition of the proceeding
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:dispositionOfProceeding" />
				</div>
			</td>
		</tr>
		</table>
	</xsl:template>
	<xsl:template name="mode_authorizationDeniedOrSuspendedDetails">
      <p>
				Entity information Related to item 10(c)(3) Record:
				<xsl:value-of select="position()" />
		</p>
    <table role="presentation">
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(c)(3)(i). </b>
				</font>
				The individuals named in the Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(c)(3)(ii). </b>
				</font>
				Title of Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:actionTitle" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(c)(3)(iii). </b>
				</font>
				Date of Action
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:actionDate" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(c)(3)(iv). </b>
				</font>
				The Court or body taking the Action and its location
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:courtOrBodyNameAndLocation" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(c)(3)(v). </b>
				</font>
				Description of the Action
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:actionDescription" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(c)(3)(vi). </b>
				</font>
				The disposition of the proceeding
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:dispositionOfProceeding" />
				</div>
			</td>
		</tr>
		</table>
	</xsl:template>
	<xsl:template name="mode_registrationDeniedOrSuspendedDetails">
        <p>
				Entity information Related to item 10(c)(4) Record:
				<xsl:value-of select="position()" />
		  </p>
    <table role="presentation">
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(c)(4)(i). </b>
				</font>
				The individuals named in the Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(c)(4)(ii). </b>
				</font>
				Title of Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:actionTitle" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(c)(4)(iii). </b>
				</font>
				Date of Action
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:actionDate" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(c)(4)(iv). </b>
				</font>
				The Court or body taking the Action and its location
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:courtOrBodyNameAndLocation" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(c)(4)(v). </b>
				</font>
				Description of the Action
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:actionDescription" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(c)(4)(vi). </b>
				</font>
				The disposition of the proceeding
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:dispositionOfProceeding" />
				</div>
			</td>
		</tr>
		</table>
	</xsl:template>

	<!-- *10(d). -->
	<!-- 10(d)(1) -->
	<xsl:template name="mode_fsrFalseStatementOrOmissionDetails">
      <p>
				Entity information Related to item 10(d)(1) Record:
				<xsl:value-of select="position()" />
		</p>
    <table role="presentation">
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(1)(i). </b>
				</font>
				The individuals named in the Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(1)(ii). </b>
				</font>
				Title of Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:actionTitle" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(1)(iii). </b>
				</font>
				Date of Action
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:actionDate" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(1)(iv). </b>
				</font>
				The Court or body taking the Action and its location
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:courtOrBodyNameAndLocation" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(1)(v). </b>
				</font>
				Description of the Action
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:actionDescription" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(1)(vi). </b>
				</font>
				The disposition of the proceeding
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:dispositionOfProceeding" />
				</div>
			</td>
		</tr>
		</table>
	</xsl:template>
	<!-- 10(d)(2) -->
	<xsl:template name="mode_fsrViolationOfInvestmentRelatedRegulationDetails">
    <p>
				Entity information Related to item 10(d)(2) Record:
				<xsl:value-of select="position()" />
	 </p>
    <table role="presentation">
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(2)(i). </b>
				</font>
				The individuals named in the Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(2)(ii). </b>
				</font>
				Title of Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:actionTitle" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(2)(iii). </b>
				</font>
				Date of Action
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:actionDate" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(2)(iv). </b>
				</font>
				The Court or body taking the Action and its location
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:courtOrBodyNameAndLocation" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(2)(v). </b>
				</font>
				Description of the Action
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:actionDescription" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(2)(vi). </b>
				</font>
				The disposition of the proceeding
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:dispositionOfProceeding" />
				</div>
			</td>
		</tr>
		</table>
	</xsl:template>
	<!-- 10(d)(3) -->
	<xsl:template name="mode_fsrAuthorizationDeniedOrSuspendedDetails">
         <p>
				Entity information Related to item 10(d)(3) Record:
				<xsl:value-of select="position()" />
			</p>
    <table role="presentation">
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(3)(i). </b>
				</font>
				The individuals named in the Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(3)(ii). </b>
				</font>
				Title of Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:actionTitle" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(3)(iii). </b>
				</font>
				Date of Action
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:actionDate" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(3)(iv). </b>
				</font>
				The Court or body taking the Action and its location
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:courtOrBodyNameAndLocation" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(3)(v). </b>
				</font>
				Description of the Action
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:actionDescription" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(3)(vi). </b>
				</font>
				The disposition of the proceeding
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:dispositionOfProceeding" />
				</div>
			</td>
		</tr>
		</table>
	</xsl:template>
	<!-- 10(d)(4) -->
	<xsl:template name="mode_fsrFoundOrderAgainstApplicantDetails">
       <p>
				Entity information Related to item 10(d)(4) Record:
				<xsl:value-of select="position()" />
		 </p>
     <table role="presentation">				
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(4)(i). </b>
				</font>
				The individuals named in the Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(4)(ii). </b>
				</font>
				Title of Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:actionTitle" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(4)(iii). </b>
				</font>
				Date of Action
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:actionDate" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(4)(iv). </b>
				</font>
				The Court or body taking the Action and its location
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:courtOrBodyNameAndLocation" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(4)(v). </b>
				</font>
				Description of the Action
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:actionDescription" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(4)(vi). </b>
				</font>
				The disposition of the proceeding
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:dispositionOfProceeding" />
				</div>
			</td>
		</tr>
		</table>
	</xsl:template>
	<!-- 10(d)(5) -->
	<xsl:template name="mode_fsrRegistrationDeniedOrSuspendedDetails">
		<p>
				Entity information Related to item 10(d)(5) Record:
				<xsl:value-of select="position()" />
		</p>
    <table role="presentation">
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(5)(i). </b>
				</font>
				The individuals named in the Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(5)(ii). </b>
				</font>
				Title of Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:actionTitle" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(5)(iii). </b>
				</font>
				Date of Action
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:actionDate" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(5)(iv). </b>
				</font>
				The Court or body taking the Action and its location
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:courtOrBodyNameAndLocation" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(5)(v). </b>
				</font>
				Description of the Action
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:actionDescription" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(5)(vi). </b>
				</font>
				The disposition of the proceeding
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:dispositionOfProceeding" />
				</div>
			</td>
		</tr>
		</table>
	</xsl:template>
	<!-- 10(d)(6) -->
	<xsl:template name="mode_fsrRevokedSuspendedLicenseDetails">
     <p>
				Entity information Related to item 10(d)(6) Record:
				<xsl:value-of select="position()" />
		</p>
    <table role="presentation">
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(6)(i). </b>
				</font>
				The individuals named in the Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(6)(ii). </b>
				</font>
				Title of Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:actionTitle" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(6)(iii). </b>
				</font>
				Date of Action
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:actionDate" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(6)(iv). </b>
				</font>
				The Court or body taking the Action and its location
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:courtOrBodyNameAndLocation" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(6)(v). </b>
				</font>
				Description of the Action
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:actionDescription" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(d)(6)(vi). </b>
				</font>
				The disposition of the proceeding
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:dispositionOfProceeding" />
				</div>
			</td>
		</tr>
		</table>
	</xsl:template>

	<!-- *10(e). -->
	<!-- 10(e)(1) -->
	<xsl:template name="mode_sraFalseStatementOrOmissionDetails">
      <p>
				Entity information Related to item 10(e)(1) Record:
				<xsl:value-of select="position()" />
		</p>
    <table role="presentation">
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(e)(1)(i). </b>
				</font>
				The individuals named in the Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(e)(1)(ii). </b>
				</font>
				Title of Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:actionTitle" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(e)(1)(iii). </b>
				</font>
				Date of Action
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:actionDate" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(e)(1)(iv). </b>
				</font>
				The Court or body taking the Action and its location
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:courtOrBodyNameAndLocation" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(e)(1)(v). </b>
				</font>
				Description of the Action
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:actionDescription" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(e)(1)(vi). </b>
				</font>
				The disposition of the proceeding
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:dispositionOfProceeding" />
				</div>
			</td>
		</tr>
		</table>
	</xsl:template>
	<!-- 10(e)(2) -->
	<xsl:template name="mode_sraViolationOfRulesDetails">
      <p>
				Entity information Related to item 10(e)(2) Record:
				<xsl:value-of select="position()" />
		</p>
    <table role="presentation">
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(e)(2)(i). </b>
				</font>
				The individuals named in the Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(e)(2)(ii). </b>
				</font>
				Title of Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:actionTitle" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(e)(2)(iii). </b>
				</font>
				Date of Action
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:actionDate" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(e)(2)(iv). </b>
				</font>
				The Court or body taking the Action and its location
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:courtOrBodyNameAndLocation" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(e)(2)(v). </b>
				</font>
				Description of the Action
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:actionDescription" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(e)(2)(vi). </b>
				</font>
				The disposition of the proceeding
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:dispositionOfProceeding" />
				</div>
			</td>
		</tr>
		</table>
	</xsl:template>
	<!-- 10(e)(3) -->
	<xsl:template name="mode_sraAuthorizationDeniedOrSuspendedDetails">
       <p>
				Entity information Related to item 10(e)(3) Record:
				<xsl:value-of select="position()" />
		 </p>
    <table role="presentation">
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(e)(3)(i). </b>
				</font>
				The individuals named in the Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(e)(3)(ii). </b>
				</font>
				Title of Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:actionTitle" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(e)(3)(iii). </b>
				</font>
				Date of Action
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:actionDate" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(e)(3)(iv). </b>
				</font>
				The Court or body taking the Action and its location
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:courtOrBodyNameAndLocation" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(e)(3)(v). </b>
				</font>
				Description of the Action
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:actionDescription" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(e)(3)(vi). </b>
				</font>
				The disposition of the proceeding
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:dispositionOfProceeding" />
				</div>
			</td>
		</tr>
		</table>
	</xsl:template>
	<!-- 10(e)(4) -->
	<xsl:template name="mode_sraRevokedSuspendedLicenseDetails">
      <p>
				Entity information Related to item 10(e)(4) Record:
				<xsl:value-of select="position()" />
		</p>
    <table role="presentation">
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(e)(4)(i). </b>
				</font>
				The individuals named in the Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(e)(4)(ii). </b>
				</font>
				Title of Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:actionTitle" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(e)(4)(iii). </b>
				</font>
				Date of Action
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:actionDate" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(e)(4)(iv). </b>
				</font>
				The Court or body taking the Action and its location
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:courtOrBodyNameAndLocation" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(e)(4)(v). </b>
				</font>
				Description of the Action
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:actionDescription" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(e)(4)(vi). </b>
				</font>
				The disposition of the proceeding
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:dispositionOfProceeding" />
				</div>
			</td>
		</tr>
		</table>
	</xsl:template>
	<!-- 10(f). -->
	<xsl:template name="mode_foreignAgencyDetails">
			<p>
				Entity information Related to item 10(f) Record:
				<xsl:value-of select="position()" />
			</p>
    <table role="presentation">
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(f)(i). </b>
				</font>
				The individuals named in the Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(f)(ii). </b>
				</font>
				Title of Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:actionTitle" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(f)(iii). </b>
				</font>
				Date of Action
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:actionDate" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(f)(iv). </b>
				</font>
				The Court or body taking the Action and its location
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:courtOrBodyNameAndLocation" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(f)(v). </b>
				</font>
				Description of the Action
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:actionDescription" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(f)(vi). </b>
				</font>
				The disposition of the proceeding
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:dispositionOfProceeding" />
				</div>
			</td>
		</tr>
		</table>
	</xsl:template>
	<!-- 10(g). -->
	<xsl:template name="mode_subjectOfProceedingsDetails">
			<p>
				Entity information Related to item 10(g) Record:
				<xsl:value-of select="position()" />
			</p>
    <table role="presentation">
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(g)(i). </b>
				</font>
				The individuals named in the Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(g)(ii). </b>
				</font>
				Title of Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:actionTitle" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(g)(iii). </b>
				</font>
				Date of Action
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:actionDate" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(g)(iv). </b>
				</font>
				The Court or body taking the Action and its location
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:courtOrBodyNameAndLocation" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(g)(v). </b>
				</font>
				Description of the Action
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:actionDescription" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(g)(vi). </b>
				</font>
				The disposition of the proceeding
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:dispositionOfProceeding" />
				</div>
			</td>
		</tr>
		</table>
	</xsl:template>
	<!-- 10(h) -->
	<xsl:template name="mode_revokedBondDetails">
		<p>
				Entity information Related to item 10(h) Record:
				<xsl:value-of select="position()" />
		</p>
    <table role="presentation">
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(h)(i). </b>
				</font>
				The individuals named in the Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(h)(ii). </b>
				</font>
				Title of Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:actionTitle" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(h)(iii). </b>
				</font>
				Date of Action
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:actionDate" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(h)(iv). </b>
				</font>
				The Court or body taking the Action and its location
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:courtOrBodyNameAndLocation" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(h)(v). </b>
				</font>
				Description of the Action
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:actionDescription" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(h)(vi). </b>
				</font>
				The disposition of the proceeding
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:dispositionOfProceeding" />
				</div>
			</td>
		</tr>
		</table>
	</xsl:template>
	<!-- 10(i) -->
	<xsl:template name="mode_unsatisfiedJudgementOrLiensDetails">
		<p>
				Entity information Related to item 10(i) Record:
				<xsl:value-of select="position()" />
		</p>
    <table role="presentation">
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(i)(i). </b>
				</font>
				The individuals named in the Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(i)(ii). </b>
				</font>
				Title of Action
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:actionTitle" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(i)(iii). </b>
				</font>
				Date of Action
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:actionDate" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(i)(iv). </b>
				</font>
				The Court or body taking the Action and its location
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:courtOrBodyNameAndLocation" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(i)(v). </b>
				</font>
				Description of the Action
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:actionDescription" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>10(i)(vi). </b>
				</font>
				The disposition of the proceeding
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:dispositionOfProceeding" />
				</div>
			</td>
		</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>